/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.owostuff.ui.component;

import com.mojang.blaze3d.vertex.PoseStack;
import com.nyfaria.numismaticoverhaul.owostuff.ui.base.BaseComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.AnimatableProperty;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Color;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.HorizontalAlignment;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Size;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Sizing;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.VerticalAlignment;
import com.nyfaria.numismaticoverhaul.owostuff.ui.parsing.UIModel;
import com.nyfaria.numismaticoverhaul.owostuff.ui.parsing.UIParsing;
import com.nyfaria.numismaticoverhaul.owostuff.ui.util.Drawer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import org.w3c.dom.Element;

public class LabelComponent
extends BaseComponent {
    protected final Font textRenderer;
    protected Component text;
    protected List<FormattedCharSequence> wrappedText;
    protected VerticalAlignment verticalTextAlignment;
    protected HorizontalAlignment horizontalTextAlignment;
    protected final AnimatableProperty<Color> color;
    protected boolean shadow;
    protected int maxWidth;

    protected LabelComponent(Component text) {
        this.textRenderer = Minecraft.m_91087_().f_91062_;
        this.verticalTextAlignment = VerticalAlignment.TOP;
        this.horizontalTextAlignment = HorizontalAlignment.LEFT;
        this.color = AnimatableProperty.of(Color.WHITE);
        this.text = text;
        this.wrappedText = new ArrayList<FormattedCharSequence>();
        this.shadow = false;
        this.maxWidth = Integer.MAX_VALUE;
    }

    public LabelComponent text(Component text) {
        this.text = text;
        this.notifyParentIfMounted();
        return this;
    }

    public Component text() {
        return this.text;
    }

    public LabelComponent maxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        this.notifyParentIfMounted();
        return this;
    }

    public int maxWidth() {
        return this.maxWidth;
    }

    public LabelComponent shadow(boolean shadow) {
        this.shadow = shadow;
        return this;
    }

    public boolean shadow() {
        return this.shadow;
    }

    public LabelComponent color(Color color) {
        this.color.set(color);
        return this;
    }

    public AnimatableProperty<Color> color() {
        return this.color;
    }

    public LabelComponent verticalTextAlignment(VerticalAlignment verticalAlignment) {
        this.verticalTextAlignment = verticalAlignment;
        return this;
    }

    public VerticalAlignment verticalTextAlignment() {
        return this.verticalTextAlignment;
    }

    public LabelComponent horizontalTextAlignment(HorizontalAlignment horizontalAlignment) {
        this.horizontalTextAlignment = horizontalAlignment;
        return this;
    }

    public HorizontalAlignment horizontalTextAlignment() {
        return this.horizontalTextAlignment;
    }

    @Override
    protected void applyHorizontalContentSizing(Sizing sizing) {
        int widestText = 0;
        for (FormattedCharSequence line : this.wrappedText) {
            int width = this.textRenderer.m_92724_(line);
            if (width <= widestText) continue;
            widestText = width;
        }
        if (widestText > this.maxWidth) {
            this.wrapLines();
            this.applyHorizontalContentSizing(sizing);
        } else {
            this.width = widestText + sizing.value * 2;
        }
    }

    @Override
    protected void applyVerticalContentSizing(Sizing sizing) {
        this.wrapLines();
        int n = this.wrappedText.size();
        Objects.requireNonNull(this.textRenderer);
        this.height = n * (9 + 2) - 2 + sizing.value * 2;
    }

    @Override
    public void inflate(Size space) {
        super.inflate(space);
        this.wrapLines();
    }

    private void wrapLines() {
        this.wrappedText = this.textRenderer.m_92923_((FormattedText)this.text, ((Sizing)this.horizontalSizing.get()).method != Sizing.Method.CONTENT ? this.width : this.maxWidth);
    }

    @Override
    public void update(float delta, int mouseX, int mouseY) {
        super.update(delta, mouseX, mouseY);
        this.color.update(delta);
    }

    @Override
    public void draw(PoseStack matrices, int mouseX, int mouseY, float partialTicks, float delta) {
        int x = this.x;
        int y = this.y;
        if (((Sizing)this.horizontalSizing.get()).method == Sizing.Method.CONTENT) {
            x += ((Sizing)this.horizontalSizing.get()).value;
        }
        if (((Sizing)this.verticalSizing.get()).method == Sizing.Method.CONTENT) {
            y += ((Sizing)this.verticalSizing.get()).value;
        }
        switch (this.verticalTextAlignment) {
            case CENTER: {
                int n = this.wrappedText.size();
                Objects.requireNonNull(this.textRenderer);
                y += (this.height - (n * (9 + 2) - 2)) / 2;
                break;
            }
            case BOTTOM: {
                int n = this.wrappedText.size();
                Objects.requireNonNull(this.textRenderer);
                y += this.height - (n * (9 + 2) - 2);
            }
        }
        for (int i = 0; i < this.wrappedText.size(); ++i) {
            FormattedCharSequence renderText = this.wrappedText.get(i);
            int renderX = x;
            switch (this.horizontalTextAlignment) {
                case CENTER: {
                    renderX += (this.width - this.textRenderer.m_92724_(renderText)) / 2;
                    break;
                }
                case RIGHT: {
                    renderX += this.width - this.textRenderer.m_92724_(renderText);
                }
            }
            if (this.shadow) {
                this.textRenderer.m_92744_(matrices, renderText, (float)renderX, (float)(y + i * 11), ((Color)this.color.get()).argb());
                continue;
            }
            this.textRenderer.m_92877_(matrices, renderText, (float)renderX, (float)(y + i * 11), ((Color)this.color.get()).argb());
        }
    }

    @Override
    public void drawTooltip(PoseStack matrices, int mouseX, int mouseY, float partialTicks, float delta) {
        super.drawTooltip(matrices, mouseX, mouseY, partialTicks, delta);
        if (!this.isInBoundingBox(mouseX, mouseY)) {
            return;
        }
        Drawer.utilityScreen().m_96570_(matrices, this.text.m_7383_(), mouseX, mouseY);
    }

    @Override
    public boolean onMouseDown(double mouseX, double mouseY, int button) {
        return Drawer.utilityScreen().m_5561_(this.text.m_7383_()) | super.onMouseDown(mouseX, mouseY, button);
    }

    @Override
    public void parseProperties(UIModel model, Element element, Map<String, Element> children) {
        super.parseProperties(model, element, children);
        UIParsing.apply(children, "text", UIParsing::parseText, this::text);
        UIParsing.apply(children, "max-width", UIParsing::parseUnsignedInt, this::maxWidth);
        UIParsing.apply(children, "color", Color::parse, this::color);
        UIParsing.apply(children, "shadow", UIParsing::parseBool, this::shadow);
        UIParsing.apply(children, "vertical-text-alignment", VerticalAlignment::parse, this::verticalTextAlignment);
        UIParsing.apply(children, "horizontal-text-alignment", HorizontalAlignment::parse, this::horizontalTextAlignment);
    }
}

